﻿using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{
	public partial class storage_domain_static
	{
		public storage_domain_static()
		{
		}

		public storage_domain_static(System.Guid id, System.String storage, 
			System.Int32 storage_domain_type, string storage_name)
		{
			this.Id = id;
            this.storage = storage;
			this.storage_domain_type = (StorageDomainType)storage_domain_type;
			this.storage_name = storage_name;
		}
	}

	
    public partial class storage_domains
	{
		public storage_domains()
		{
            StorageStaticData = new storage_domain_static();
            StorageDynamicData = new storage_domain_dynamic();
			StoragePoolIsoMapData = new storage_pool_iso_map();
		}

        [XmlIgnoreAttribute]
        public System.Guid id
		{
			get { return this.StorageStaticData.Id; }
			set 
			{ 
				StorageStaticData.Id = value;
				StorageDynamicData.Id = value;
				StoragePoolIsoMapData.storage_id = value;
			}
		}

        [XmlIgnoreAttribute]
        public System.String storage
		{
			get { return StorageStaticData.storage; }
			set { StorageStaticData.storage = value; }
		}

        [XmlIgnoreAttribute]
        public System.String storage_name
		{
			get { return StorageStaticData.storage_name; }
			set
			{
				if (StorageStaticData.storage_name != value)
				{
					StorageStaticData.storage_name = value;
					this.RaisePropertyChanged("storage_name");
				}
			}
		}

        [XmlIgnoreAttribute]
        public Nullable<System.Guid> storage_pool_id
		{
			get { return StoragePoolIsoMapData.storage_pool_id; }
			set 
			{ 
				StoragePoolIsoMapData.storage_pool_id = value;
		}
		}

        [XmlIgnoreAttribute]
        public Nullable<System.Int32> available_disk_size
		{
			get { return StorageDynamicData.available_disk_size; }
            set
            {
                StorageDynamicData.available_disk_size = value;
                this.RaisePropertyChanged("available_disk_size");
                UpdateTotalDiskSize();
                UpdateOverCommitPercent();
            }
		}

        private void UpdateOverCommitPercent()
        {
            storage_domain_over_commit_percent = available_disk_size.HasValue && available_disk_size.Value > 0 ?
                 committed_disk_size * 100 /
                available_disk_size.Value : 0;
        }

        private int _storage_domain_over_commit_percent;
        [XmlIgnoreAttribute]
        public int storage_domain_over_commit_percent
        {
            get
            {
                return _storage_domain_over_commit_percent;
            }
            set
            {
                _storage_domain_over_commit_percent = value;
                this.RaisePropertyChanged("storage_domain_over_commit_percent");
            }
        }

        [XmlIgnoreAttribute]
        public Nullable<System.Int32> used_disk_size
		{
			get { return StorageDynamicData.used_disk_size; }
			set
			{
               
				StorageDynamicData.used_disk_size = value;
				this.RaisePropertyChanged("used_disk_size");
				UpdateTotalDiskSize();
			}
		}

		private void UpdateTotalDiskSize()
		{
			int? available = StorageDynamicData.available_disk_size;
			int? used = StorageDynamicData.used_disk_size;

			if (available.HasValue && used.HasValue)
			{
				TotalDiskSize = available.Value + used.Value;
			}
			else
			{
				TotalDiskSize = null;
			}
		}

		private int? totalDiskSize;
        [XmlIgnoreAttribute]
        public int? TotalDiskSize
		{
			get
			{
				UpdateTotalDiskSize();
				return totalDiskSize;
			}
			set
			{
				if (totalDiskSize != value)
				{
					totalDiskSize = value;
					this.RaisePropertyChanged("TotalDiskSize");
				}
			}
		}

        [XmlIgnoreAttribute]
        public Nullable<StorageDomainStatus> status
        {
            get { return StoragePoolIsoMapData.status; }
            set
            {
                if (StoragePoolIsoMapData.status != value)
                {
                    StoragePoolIsoMapData.status = value.Value;
                    this.RaisePropertyChanged("status");
                }
            }
        }

     
        [XmlIgnoreAttribute]
        public StorageDomainType storage_domain_type
        {
            get { return StorageStaticData.storage_domain_type; }
            set
            {
                StorageStaticData.storage_domain_type = value;
                this.RaisePropertyChanged("storage_domain_type");
            }
        }
		#region IVdcQueryable Members
        //public event PropertyChangedEventHandler PropertyChanged;
        [XmlIgnoreAttribute]
		public override object QueryableId
		{
			get
			{
				return string.Format("{0}_{1}", id.ToString(),
					storage_pool_id.HasValue ? storage_pool_id.Value.ToString() : Guid.Empty.ToString());
		}
		}
		#endregion
		#region INotifyPropertyChanged Members

		private static readonly List<string> _spProperties =
			new List<string>
			{
				"storage_name",
				"status",
				"used_disk_size",
				"available_disk_size",
				"committed_disk_size",
				"storage_domain_type",
				"storage_domain_shared_status",
				"storage"
			};

        [XmlIgnoreAttribute]
		public override List<string> ChangeablePropertiesList
		{
			get { return _spProperties; }
		}

       
		#endregion

		public override bool Equals(object obj)
		{
			bool returnValue = base.Equals(obj);
			if (!returnValue && obj != null && obj is storage_domains)
			{
				returnValue = (QueryableId.Equals((obj as storage_domains).QueryableId));
			}
			return returnValue;
		}
		public override int GetHashCode()
		{
			return QueryableId.GetHashCode();
		}
	}
}

